local t = Def.ActorFrame {
	LoadFont("_frutiger lt std 55","roman 24px") .. {
		Name="SMVersion";
		Text="StepMania "..ProductVersion();
		InitCommand=cmd(x,SCREEN_RIGHT-20;y,SCREEN_TOP+20;horizalign,right;shadowlength,0);
		OnCommand=cmd(diffuse,0,0,0,1;zoom,0.6);
	};
	
	LoadFont("_frutiger lt std 55","roman 24px") .. {
		Name="Date";
		Text="Today is ".. MonthOfYear()+1 .. "/" .. DayOfMonth() .. "/" .. Year() ..".";
		InitCommand=cmd(x,SCREEN_RIGHT-20;y,SCREEN_TOP+36;horizalign,right;shadowlength,0);
		OnCommand=cmd(diffuse,0,0,0,1;zoom,0.6);
	};
	LoadFont("_frutiger lt std 55","roman 24px") .. {
		Name="Clock";
		InitCommand=cmd(x,SCREEN_RIGHT-20;y,SCREEN_TOP+52;horizalign,right;shadowlength,0);
		OnCommand=cmd(diffuse,0,0,0,1;zoom,0.6);
	};
	
	Def.ActorFrame{
		Name="AvailableData";
		InitCommand=cmd(x,SCREEN_LEFT+10;y,SCREEN_TOP+16);
		OnCommand=cmd(playcommandonchildren,"Align");
		AlignCommand=cmd(horizalign,left);
		
		LoadFont("_frutiger lt std 55","roman 24px") .. {
			Name="SongNum";
			Text=SONGMAN:GetNumSongs();
			InitCommand=cmd(shadowlength,0;diffuse,color("#FF00DD");skewx,-0.2;zoom,0.8);
		};
		LoadFont("_frutiger lt std 55","roman 24px") .. {
			Name="SongText";
			InitCommand=cmd(shadowlength,0;diffuse,color("#000000");zoom,0.6);
			OnCommand=function(self)
				local num = self:GetParent():GetChild("SongNum"):GetWidth()
				self:x(num-2)
				local text = "songs";
				if SONGMAN:GetNumSongs() == 1 then text= "song" end;
				self:settext(text);
			end;
		};
		
		LoadFont("_frutiger lt std 55","roman 24px") .. {
			Name="GroupNum";
			Text=SONGMAN:GetNumSongGroups();
			InitCommand=cmd(addy,16;shadowlength,0;diffuse,color("#FF00DD");skewx,-0.2;zoom,0.8);
		};
		LoadFont("_frutiger lt std 55","roman 24px") .. {
			Name="GroupText";
			InitCommand=cmd(addy,16;shadowlength,0;diffuse,color("#000000");zoom,0.6);
			OnCommand=function(self)
				local num = self:GetParent():GetChild("GroupNum"):GetWidth()
				self:x(num+2)
				local text = "groups";
				if SONGMAN:GetNumSongs() == 1 then text= "group" end;
				self:settext(text);
			end;
		};
		
		LoadFont("_frutiger lt std 55","roman 24px") .. {
			Name="CourseNum";
			Text=SONGMAN:GetNumCourses();
			InitCommand=cmd(addy,32;shadowlength,0;diffuse,color("#FF00DD");skewx,-0.2;zoom,0.8);
		};
		LoadFont("_frutiger lt std 55","roman 24px") .. {
			Name="CourseText";
			InitCommand=cmd(addy,32;shadowlength,0;diffuse,color("#000000");zoom,0.6);
			OnCommand=function(self)
				local num = self:GetParent():GetChild("CourseNum"):GetWidth()
				self:x(num+2)
				local text = "courses";
				if SONGMAN:GetNumCourses() == 1 then text = "course" end;
				if getenv("Humor") and SONGMAN:GetNumCourses() == 37 then text = "go away pondermatic" end;
				self:settext(text);
			end;
		};
	};
	
	LoadFont("_frutiger lt std 55","roman 24px") .. {
		Name="Gametype";
		Text="Gametype: "..GAMESTATE:GetCurrentGame():GetName();
		InitCommand=cmd(x,SCREEN_LEFT+10;y,SCREEN_TOP+64;horizalign,left;shadowlength,0);
		OnCommand=cmd(diffuse,0,0,0,1;zoom,0.6);
	};
};

-- Better documentation for this specific instance of Update can be found in
-- the ScreenClockTest overlay folder.
local function Update(self)
	local clock = self:GetChild("Clock");
	
	local hour = Hour();
	local min = Minute();
	local sec = Second();
	clock:settext( "It's currently ".. string.format( '%02i:%02i:%02i', hour, min, sec ).. "." );
end;

t.InitCommand=cmd(SetUpdateFunction,Update);

return t;
